# Installation
> `npm install --save @types/leaflet-boundary-canvas`

# Summary
This package contains type definitions for leaflet-boundary-canvas (https://github.com/ttungbmt/leaflet-boundary-canvas#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/leaflet-boundary-canvas.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/leaflet-boundary-canvas/index.d.ts)
````ts
import type { FeatureCollection } from "geojson";
import * as L from "leaflet";

declare module "leaflet" {
    namespace TileLayer {
        interface BoundaryCanvasOptions extends TileLayerOptions {
            boundary?: FeatureCollection | undefined;
            crossOrigin?: boolean | undefined;
            trackAttribution?: boolean | undefined;
        }

        class BoundaryCanvas extends TileLayer {
            constructor(url: string, options?: BoundaryCanvasOptions);
            static createFromLayer(tileLayer: TileLayer, options?: BoundaryCanvasOptions): BoundaryCanvas;
        }

        function boundaryCanvas(url: string, options?: BoundaryCanvasOptions): BoundaryCanvas;
    }
}

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:38 GMT
 * Dependencies: [@types/geojson](https://npmjs.com/package/@types/geojson), [@types/leaflet](https://npmjs.com/package/@types/leaflet)

# Credits
These definitions were written by [TurtIeSocks](https://github.com/TurtIeSocks).
